//tree view
#include <struct.h>
#include "TreeView.h"
#include "LinkedList.h"
#include "resource.h"

HINSTANCE g_dllHandle;

BEGIN_MESSAGE_MAP(CHView, CTreeView)
  ON_WM_MOUSEACTIVATE()
  ON_WM_MOUSEMOVE()
  ON_WM_LBUTTONUP()
  ON_WM_LBUTTONDOWN()
END_MESSAGE_MAP()

CHView::CHView() : CTreeView()
{
  Images.Create(IDB_ICONS, 16, 2, 0xFFFFFF);
  m_pDragImage  = NULL;
  hTarget       = NULL;
  hDrag         = NULL;
}

CHView::~CHView()
{
  if (m_pDragImage)
    delete m_pDragImage;
}


//--------------------------------
// makes node according to the list
void CHView::ReloadFromList()
{
  CTreeCtrl& Tree = GetTreeCtrl();
  Tree.SetImageList(&Images, TVSIL_NORMAL);
  Tree.DeleteAllItems();

  LoadChildren(TVI_ROOT, NULL);
}


void CHView::LoadChildren(HTREEITEM parent, const char* pParName)
{
  HTREEITEM node;
  lpNamedRef ptr = NULL;
  CTreeCtrl& Tree = GetTreeCtrl();
  while (FindNextChild(g_pHList, pParName, ptr ? ptr->pChild : NULL, &ptr))
  {
    int img = HasChild(g_pHList, ptr->pChild) ? 0:1;
    node = Tree.InsertItem(
              ptr->pChild,
              img,
              img,
              parent);
    LoadChildren(node, ptr->pChild);
  }
}

int CHView::OnMouseActivate(CWnd* pDesktopWnd, UINT nHitTest, UINT message)
{
  return MA_ACTIVATE;
}

//-------------------------------------------
// drag and drop stuff
//-------------------------------------------
void CHView::BeginDrag()
{
  //get current HTREEITEM
  hDrag = GetTreeCtrl().GetSelectedItem();
  if (m_pDragImage)
    delete m_pDragImage;
  m_pDragImage = GetTreeCtrl().CreateDragImage(hDrag);
  if (m_pDragImage)
    m_pDragImage->BeginDrag(0, DragPos);
  hTarget       = NULL;
}


void CHView::OnMouseMove(UINT nFlags, CPoint loc)
{
  if (0 == (nFlags & MK_LBUTTON))
    return;
  //is dragging?
  if (!m_pDragImage)
    return;

  UINT flags;
  HTREEITEM hOver = GetTreeCtrl().HitTest( loc, &flags);
  if (hOver != hTarget)
  {
    hTarget = hOver;
    m_pDragImage->DragShowNolock(FALSE);
    GetTreeCtrl().SelectDropTarget(hOver);
  }
  
  ClientToScreen(&loc);
  m_pDragImage->DragMove(loc);
  m_pDragImage->DragShowNolock(TRUE);
}

//----------------------------
// select with single click
void CHView::OnLButtonDown(UINT nFlags, CPoint loc)
{
  HTREEITEM hOver = GetTreeCtrl().HitTest( loc, &nFlags);
  if ((nFlags == TVHT_ONITEMLABEL) && hOver)
  {
    GetTreeCtrl().SelectItem(hOver);
    GetTreeCtrl().SelectDropTarget(hOver);
    RECT rect;
    GetTreeCtrl().GetItemRect(hOver, &rect, TRUE);
    DragPos.x = loc.x-rect.left+16;
    DragPos.y = loc.y-rect.top;
  }
  Default();
}


void CHView::OnLButtonUp(UINT nFlags, CPoint loc)
{
  if (m_pDragImage)
  {
    m_pDragImage->EndDrag();
    delete m_pDragImage;
  }
  m_pDragImage  = NULL;
  BOOL reload_from_list = FALSE;
  CTreeCtrl& Tree = GetTreeCtrl();

  if (hDrag != hTarget)
  {//process dragging
    HTREEITEM hParent = hTarget;
    while(NULL != (hParent = Tree.GetParentItem(hParent)))
      if (hParent == hDrag)
        break;
    
    if (hParent != hDrag)
    {//do list changes
      CString oldItem;
      CString newParent;
      oldItem = Tree.GetItemText(hDrag);
      newParent = Tree.GetItemText(hTarget);
      char* pOldBuf = oldItem.GetBuffer(64);
      char* pNewBuf = newParent.GetBuffer(64);
      MoveNode(
        g_pHList,
        (pOldBuf[0] == '\0') ? NULL : pOldBuf,
        (pNewBuf[0] == '\0') ? NULL : pNewBuf);
      newParent.ReleaseBuffer();
      oldItem.ReleaseBuffer();
    }

    if (Tree.ItemHasChildren( hDrag ))
    {//drag with children - perform list change and then reload from list.
      reload_from_list = TRUE;
    }
    else
    {
      //do item/image swap
      int img;
      hParent = Tree.GetParentItem(hDrag);
      Tree.GetItemImage(hDrag, img, img);
      CString text = Tree.GetItemText(hDrag);
      Tree.DeleteItem(hDrag);
      Tree.InsertItem(text, img, img, hTarget);
      if (hParent && !Tree.ItemHasChildren( hParent ))
        Tree.SetItemImage(hParent, 1, 1);//has lost all children
      if (hTarget)
        Tree.SetItemImage(hTarget, 0, 0);//now surely a parent
    }
  }

  hTarget       = NULL;
  hDrag         = NULL;
  if (reload_from_list)
    ReloadFromList();
  InvalidateRect(NULL);
}



